<?php
// +----------------------------------------------------------------------
// | 卡密狗 [ https://kmg.hvzhan.com ]
// +----------------------------------------------------------------------
// | Copyright (c) 2022 卡密狗 All rights reserved.
// +----------------------------------------------------------------------
// | Author: 小生 <85596003@qq.com>
// +----------------------------------------------------------------------
namespace app\controller;

use app\BaseController;

use app\model\Cate as cate;
use app\model\Goods as goods;
use app\model\Kami as kami;
use app\model\Order as order;
use app\model\OrderList as orderlist;
use app\model\Links as links;
use app\model\Banner as banner;

class Index extends BaseController
{
    protected $links;
    public function initialize()
    {
        if(__get_set('anquan')['switch']==0){
            die('<h2>网站已被管理员关闭！</h2>');
        }
        $this->links = links::select();
    }
    public function index()
    {
        $list = $this->_index();
        $banner = banner::order('sort','desc')->select();
        return view('index',[
            'list'=>$list,
            'banner'=>$banner,
            'links'=>$this->links
        ]);
    }
    public function category($links)
    {
        $cate = cate::where('links',$links)->field('id,name')->find();
        $list = goods::where(['cate_id'=>$cate['id'],'status'=>1])->field('id,title,pay_sum,img,money,kucun,auto')->order('create_time','desc')->paginate(32);
        $count = goods::where(['cate_id'=>$cate['id'],'status'=>1])->count();
        return view()->assign([
            'cate'=>$cate,
            'list'=>$list,
            'count'=>$count,
            'links'=>$this->links
        ]);
    }
    public function tag($keywords='')
    {
        if($keywords==''){
            $keywords = input('keywords');
        }
        $list = goods::where('title|tags','like','%'.$keywords.'%')->where('status',1)->field('id,title,cate_id,img,money,kucun,auto')->select();
        $count = goods::where('title|tags','like','%'.$keywords.'%')->where('status',1)->count();
        return view()->assign([
            'keywords'=>$keywords,
            'list'=>$list,
            'count'=>$count,
            'links'=>$this->links
        ]);
    }  
    public function goods($id)
    {
        $goods = goods::where('id',$id)->find();
        if($goods['status']==0){
            return $this->error('商品不存在');
        }
        if(request()->isPost()){
            return $this->_buy();
        }
        $newgoods = goods::where('status',1)->order('create_time','desc')->field('id,title,pay_sum,img,money,kucun,auto')->limit(6)->select();

        $tag = explode(',',$goods['tags']);
        //猜你喜欢
        $where = '';
        if(is_array($tag)){
            foreach($tag as $val){
                $where .= " title like '%$val%' or";
            }
            $where = rtrim($where,'or');
        }
        $cai = goods::where($where)->where('status',1)->limit(6)->select();
        $pay = __get_set('pay');
        return view('goods',[
            'goods'=>$goods,
            'newgoods'=>$newgoods,
            'cai'=>$cai,
            'tag'=>$tag,
            'pay'=>$pay,
            'links'=>$this->links
        ]);
    }
    public function notify()
    {
        return $this->_notify();
    }
    public function check()
    {
        $order = input('order');
        
        if($order){
            $pass= order::where('password',$order)->find();
            if($pass){
                $list = order::where('password',$order)->order('id desc')->select();
            }else{
                $list = order::where('order_id',$order)->find();
                if($list){
                    if($list['status']==0){
                        return $this->error('订单未支付');
                    }
                    $kamilist = orderlist::where('order_id',$list['id'])->select();
                    return view('check_list',['list'=>$list,'kamilist'=>$kamilist,'links'=>$this->links]);
                }else{
                    $list = array();
                }
                
            }
        }else{
            $list = array();
        }
        return view('check',[
            'list'=>$list,
            'links'=>$this->links
        ]);
    }
    /**
     * 确认收货
     */
    public function Confirm_receipt(){
        return $this->_Confirm_receipt();
    }

    /**
     * 删除卡密
     */
    public function del()
    {
        $order_id = input('post.order_id');
        $del = order::where('order_id',$order_id)->delete();
        if($del){
            return json(jsoncode(1,'删除成功'));
        }else{
            return json(jsoncode(0,'删除失败'));
        }
    }

    /**
     * 导出卡密
     */
    public function exprot($id){
        return $this->_exprot($id);
    }
}
