<?php
// +----------------------------------------------------------------------
// | 卡密狗 [ https://kmg.hvzhan.com ]
// +----------------------------------------------------------------------
// | Copyright (c) 2022 卡密狗 All rights reserved.
// +----------------------------------------------------------------------
// | Author: 小生 <85596003@qq.com>
// +----------------------------------------------------------------------
namespace app\controller;

use app\BaseController;

use app\model\Cate as cate;
use app\model\Goods as goods;
use app\model\Kami as kami;
use app\model\Order as order;
use app\model\OrderList as orderlist;
use app\model\Config as config;
use app\model\Links as links;
use app\model\Banner as banner;
use app\model\Admin as adm;
use think\facade\Filesystem;
use think\facade\Validate;

class Admin extends BaseController
{
    public function initialize()
    {
        if(!Session('admin')){
            return $this->error('未登录！','/');
        }
    }
    public function index()
    {
        return $this->error('当前页面不存在');
    }

    public function main()
    {
        return view('main');
    }
    public function home()
    {
        $w['isupdate'] = $this->_isupdate();
        $w['catecount'] = cate::count();
        $w['goodscount'] = goods::count();
        $w['kamicount'] = kami::count();
        $w['okorder'] = order::where('status',3)->count();
        $w['noorder'] = order::where('status',0)->count();
        $w['daiorder'] = order::where('status',1)->count();
        $w['version'] = VERSION;
        $w['admin'] = adm::find(Session('admin'));
        $info = [
            '操作系统'=>PHP_OS,
            '运行环境'=>$_SERVER["SERVER_SOFTWARE"],
            'PHP运行方式'=>php_sapi_name(),
            'PHP版本'=>PHP_VERSION,
            'MYSQL版本' => $this->_mysql_version(),
            'ThinkPHP版本'=>\think\facade\App::version(),
            '上传附件限制'=>ini_get('upload_max_filesize'),
            '执行时间限制'=>ini_get('max_execution_time').'秒',
            '服务器时间'=>date("Y年n月j日 H:i:s"),
            '北京时间'=>gmdate("Y年n月j日 H:i:s",time()+8*3600),
            '服务器地址'=>request()->domain().' [ '.gethostbyname($_SERVER['SERVER_NAME']).' ]',
        ];
        return view('home',[
            'w'=>$w,
            'info'=>$info
        ]);
    }
    private function _mysql_version()
    {
        $version = \think\facade\Db::query("select version() as ver");
        return $version[0]['ver'];
    }
    public function cate()
    {
        $list = cate::select();
        return view('cate',['list'=>$list]);
    }
    public function cate_add()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'name'  => 'require',
                'links'=>'require',
            ];
			$msg=[
                'name.require'=>'请输入栏目名称',
                'links.require'=>'请输入英文别名',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $add = cate::insert($data);
			if($add){
				return $this->success('添加成功！');
			}else{
				return $this->error('添加失败');
			}
            
        }
        return view('cate_add');
    }
    public function cate_edit()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'name'  => 'require',
                'links'=>'require',
            ];
			$msg=[
                'name.require'=>'请输入栏目名称',
                'links.require'=>'请输入英文别名',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $add = cate::where('id',$data['id'])->update($data);
			if($add){
				return $this->success('修改成功！');
			}else{
				return $this->error('修改失败');
			}
            
        }
        $cate = cate::find(input('id'));
        return view('cate_edit',['cate'=>$cate]);
    }
    public function cate_del()
    {
        if(goods::where('cate_id',input('id'))->find()){
            return json(jsoncode(0,'该分类下存在商品，请清理后在删除！'));
        }
        $del = cate::where('id',input('id'))->delete();
        if($del){
            return json(jsoncode(1,'删除成功'));
        }else{
            return json(jsoncode(0,'删除失败'));
        }
    }
    /**
     * 修改分类状态
     */
    public function edit_cate_status(){
        $data = [
            'status'=>input('status')
        ];
        $db = cate::where('id',input('id'))->update($data);
        if($db){
            return json(jsoncode(1,'修改成功'));
        }else{
            return json(jsoncode(0,'修改失败'));
        }
    }
    public function goods()
    {
        $keywords = input('keywords');
        if ($keywords) {
            $list = goods::where('id|title', 'like', '%' . $keywords . '%')->paginate(20);
        } else {
            $list = goods::order('id desc')->paginate(20);
        }
        $count = goods::count();
        return view('goods',['list'=>$list,'count'=>$count]);
    }
    public function goods_add()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'title'  => 'require',
                'cate_id'=>'require',
                'img'=>'require',
			    'content'=>'require',
                'money'=>'require',
			];
			$msg=[
                'title.require'=>'标题不能为空',
                'cate_id.require'=>'请选择分类',
                'img.require'=>'缩略图不能为空',
			    'content.require'=>'内容不能为空',
                'money.require'=>'价格不能为空',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $data['user_id'] = 1;
            $data['create_time'] = time();
            $add = goods::insertGetId($data);
			if($add){
				return $this->success('发布成功！','/goods/'.$add);
			}else{
				return $this->error('发布失败');
			}
            
        }
        $cate = cate::select();
        return view('goods_add',['cate'=>$cate]);
    }

    public function goods_edit()
    {
        $id = input('id');
        $goods = goods::where('id',$id)->find();

        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'title'  => 'require',
                'cate_id'=>'require',
                'img'=>'require',
			    'content'=>'require',
                'money'=>'require',
			];
			$msg=[
                'title.require'=>'标题不能为空',
                'cate_id.require'=>'请选择分类',
                'img.require'=>'缩略图不能为空',
			    'content.require'=>'内容不能为空',
                'money.require'=>'价格不能为空',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $data['update_time'] = time();
            $up = goods::where('id',input('goods_id'))->update($data);
			if($up){
				return $this->success('修改成功！','/goods/'.input('goods_id'));
			}else{
				return $this->error('修改失败');
			}
            
        }
        $cate = cate::select();
        return view()->assign(['goods'=>$goods,'cate'=>$cate]);
    }

    /**
     * 删除商品
     */
    public function goods_del(){
        return $this->_goods_del();
    }

    public function kami_add()
    {
        return $this->_kami_add();
    }
    /**
     * 管理卡密
     */
    public function kami_list(){
        $goods = goods::find(input('id'));
        $keywords = input('keywords');
        if ($keywords) {
            $list = kami::where('id|content', 'like', '%' . $keywords . '%')->paginate(20);
        } else {
            $list = kami::where('goods_id',input('id'))->paginate(20);
        }
        $count = kami::where('goods_id',input('id'))->count();
        return view('kami_list',['list'=>$list,'goods'=>$goods,'count'=>$count]);
    }
    /**
     * 删除卡密
     */
    public function kami_del(){
        return $this->_kami_del();
    }
    /**
     * 修改商品状态
     */
    public function edit_status(){
        $data = [
            'status'=>input('status')
        ];
        $db = goods::where('id',input('id'))->update($data);
        if($db){
            return json(jsoncode(1,'修改成功'));
        }else{
            return json(jsoncode(0,'修改失败'));
        }
    }

    /**
     * 订单列表
     */
    public function order()
    {
        $keywords = input('keywords');
        if ($keywords) {
            $list = order::where('id|order_id', 'like', '%' . $keywords . '%')->paginate(20);
        } else {
            $list = order::order('id desc')->paginate(20);
        }
        $count = order::count();
        return view('order',['list'=>$list,'count'=>$count]);
    }
    /**
     * 删除订单
     */
    public function order_del()
    {
        return $this->_order_del();
    }
    /**
     * 发货
     */
    public function fahuo()
    {
        return $this->_fahuo();
    }
    public function links()
    {
        $keywords = input('keywords');
        if ($keywords) {
            $list = links::where('id|name|url', 'like', '%' . $keywords . '%')->paginate(20);
        } else {
            $list = links::order('id desc')->paginate(20);
        }
        $count = links::count();
        return view()->assign([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    public function links_add()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'name'  => 'require',
                'url'=>'require',
            ];
			$msg=[
                'name.require'=>'请输入网站名称',
                'url.require'=>'请输入网站域名',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    return $this->error($result);
			}
            $add = links::insert($data);
			if($add){
				return $this->success('添加成功！');
			}else{
				return $this->error('添加失败');
			}
        }
        return view();
    }
    public function links_edit()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'name'  => 'require',
                'url'=>'require',
            ];
			$msg=[
                'name.require'=>'请输入网站名称',
                'url.require'=>'请输入网站域名',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $up = links::where('id',input('id'))->update($data);
			if($up){
				return $this->success('修改成功！');
			}else{
				return $this->error('修改失败');
			}
        }
        $links = links::find(input('id'));
        return view()->assign([
            'links'=>$links
        ]);
    }
    public function links_del()
    {
        $id = input('id');
        $sql = links::where('id',$id)->delete();
        if($sql){
            return json(jsoncode(1,'删除成功'));
        }else{
            return json(jsoncode(0,'删除失败'));
        }
    }
    public function banner()
    {
        $keywords = input('keywords');
        if ($keywords) {
            $list = banner::where('id|name|url', 'like', '%' . $keywords . '%')->paginate(20);
        } else {
            $list = banner::order('id desc')->paginate(20);
        }
        $count = banner::count();
        return view()->assign([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    public function banner_add()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'name'  => 'require',
                'url'=>'require',
            ];
			$msg=[
                'name.require'=>'请输入网站名称',
                'url.require'=>'请输入网站域名',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $add = banner::insert($data);
			if($add){
				return $this->success('添加成功！');
			}else{
				return $this->error('添加失败');
			}
        }
        return view();
    }
    public function banner_edit()
    {
        if(request()->isPost()){
            
            $data = input('data');
			$rule=[
                'name'  => 'require',
                'url'=>'require',
            ];
			$msg=[
                'name.require'=>'请输入网站名称',
                'url.require'=>'请输入网站域名',
			];
			$result=$this->validate($data,$rule,$msg);
			if(true !== $result){
			    // 验证失败 输出错误信息
			    return $this->error($result);
			}
            $up = banner::where('id',input('id'))->update($data);
			if($up){
				return $this->success('修改成功！');
			}else{
				return $this->error('修改失败');
			}
        }
        $banner = banner::find(input('id'));
        return view()->assign([
            'banner'=>$banner
        ]);
    }
    public function banner_del()
    {
        $id = input('id');
        $sql = banner::where('id',$id)->delete();
        if($sql){
            return json(jsoncode(1,'删除成功'));
        }else{
            return json(jsoncode(0,'删除失败'));
        } 
    }
    public function set()
    {
        if(request()->isPost()){
            $data = input('data');
            if(empty($data['is_alipay'])){
                $data['is_alipay'] = 0;
            }else{
                $data['is_alipay'] = 1;
            }
            if(empty($data['is_wxpay'])){
                $data['is_wxpay'] = 0;
            }else{
                $data['is_wxpay'] = 1;
            }
            if(empty($data['is_qqpay'])){
                $data['is_qqpay'] = 0;
            }else{
                $data['is_qqpay'] = 1;
            }
            return __set(input('type'),$data);
        }
        $set = __get_set('set');
        $pay = __get_set('pay');
        $gonggao = __get_set('gonggao');
        $anquan = __get_set('anquan');
        return view('set',['set'=>$set,'pay'=>$pay,'gonggao'=>$gonggao,'anquan'=>$anquan]);
    }
    public function update()
    {
        return $this->_update();
    }
    public function edit_password()
    {
        if(request()->isPost()){
            $pass = input('post.pass');
            $newpass = input('post.newpass');
            $newpassf = input('post.newpassf');
            if($pass=='' || !$pass){
                return $this->error('请输入原密码！');
            }
            $admin = adm::where('id',Session('admin'))->find();
            if(md5(md5($pass)) != $admin['password']){
                return $this->error('原密码不正确！');
            }
            if($newpass=='' || !$newpass){
                return $this->error('请输入新密码！');
            }
            if($newpassf=='' || !$newpassf){
                return $this->error('请输入重复密码！');
            }
            if($newpass!=$newpassf){
                return $this->error('重复密码不一致！');
            }
            $db = adm::where('id',Session('admin'))->update([
                'password'=>md5(md5($newpass))
            ]);
            if($db){
                return $this->success('修改成功');
            }else{
                return $this->error('修改失败');
            }
        }
        return view();
    }
    public function out()
    {
        Session('admin',null);
        Session('admin_name',null);
        return $this->success('退出成功！','/');
    }

    //上传源码缩略图到七牛云
	public function img()
	{
		if(request()->isPost()){
			// 获取表单上传文件 例如上传了001.jpg
            $file = request()->file('file');
            $validate = Validate::rule([
                'file' =>  'file|fileExt:jpg,png,jpeg,gif,webp,bmp'
            ]);

            $result = $validate->check([
                'file' =>  $file
            ]);

            if($result){
                $savename = Filesystem::disk('public')->putFile( 'upload', $file);
                echo '{"code":1,"msg":"上传成功","data":{"src":"/'.$savename.'"}}';
            }else{
                echo '{"code":0,"msg":"上传失败"}';
            }
		}
	}
    public function upload()
    {
        if(request()->isPost()){
			$files = request()->file('file');
            $url = [];
            foreach($files as $k => $file){

                $validate = Validate::rule([
                    'file' =>  'file|fileExt:jpg,png,jpeg,gif,webp,bmp'
                ]);

                $result = $validate->check([
                    'file' =>  $file
                ]);

                if($result){
                    $savename = Filesystem::disk('public')->putFile( 'upload', $file);
                    $url[$k]['url'] = '/'.$savename;
                    $url[$k]['name'] = '';
                    $url[$k]['error'] = 0;
                }else{
                    $url[$k]['url'] = '';
                    $url[$k]['name'] = '';
                    $url[$k]['error'] = $validate->getMessage();
                }
            }
            return json($url);
			
		}
    }
}
